<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

if (!$vbulletin->userinfo['userid'] OR !$show['downloads_cancategory'])
{
	// No permission to manage category
	print_no_permission();
}

// #############################################################################
if ($_REQUEST['action'] == 'category' OR empty($_REQUEST['action']))
{
	$categorybits = '';

	if (count(VBDOWNLOADS::$cache['category']))
	{
		$lookup = array();
		/*DBTECH_PRO_START*/
		foreach (VBDOWNLOADS::$cache['category'] as $categoryid => $category)
		{
			if (!$category['ownerid'])
			{
				// System owned
				continue;
			}
			
			// Lookup userid
			$lookup[] = $category['ownerid'];
		}
		
		if (count($lookup))
		{
			$lookup = VBDOWNLOADS::$db->fetchAllSingleKeyed('SELECT username, userid FROM $user WHERE userid :queryList', 'userid', 'username', array(':queryList' => VBDOWNLOADS::$db->queryList($lookup)));
		}
		/*DBTECH_PRO_END*/

		// Organise our categories
		$categories = construct_ordered_categories();

		foreach ($categories as $categoryid => $category)
		{
			$category['owner'] = ($lookup[$category['ownerid']] ? $lookup[$category['ownerid']] : '<b>' . $vbphrase['dbtech_downloads_no_owner'] . '</b>');
			$show['caneditcategory'] = (($category['ownerid'] == $vbulletin->userinfo['userid'] AND $vbulletin->userinfo['userid']) OR VBDOWNLOADS::$permissions['ismanager']);

			$templater = vB_Template::create('dbtech_downloads_category_list_bit');
				$templater->register('category', 	$category);
			$categorybits .= $templater->render();

			// Print children
			$categorybits .= print_category_rows_frontend($category['children'], 1, $lookup);
		}
	}

	// Add to the navbits
	$navbits[''] = $pagetitle = $vbphrase['dbtech_downloads_category_management'];
	
	// Create the archive template
	$templater = vB_Template::create('dbtech_downloads_category_list');
		$templater->register('pagetitle', 		$pagetitle);
		$templater->register('categorybits', 	$categorybits);
	$HTML = $templater->render();
}


// #############################################################################
if ($_REQUEST['action'] == 'modify')
{
	$categoryid = $vbulletin->input->clean_gpc('r', 'categoryid', TYPE_UINT);
	$category = ($categoryid ? VBDOWNLOADS::$cache['category'][$categoryid] : false);
	
	if (!is_array($category))
	{
		// Non-existing category
		$categoryid = 0;
	}
	
	$defaults = array(
		'title' 		=> 'Category',
		'description' 	=> 'A category that holds a number of downloadable files.',
		'displayorder'	=> 10,
		'image' 		=> '',
		'ownerid' 		=> 0,
	);

	// Default value
	$lookup = array(0 => '');

	if ($categoryid)
	{
		// Edit
		if ($category['ownerid'])
		{
			// If we have an owner
			$lookup = VBDOWNLOADS::$db->fetchAllSingleKeyed('SELECT username, userid FROM $user WHERE userid = ?', 'userid', 'username', array($category['ownerid']));
		}

		// Add to the navbits
		$navbits[''] = $pagetitle = construct_phrase($vbphrase['dbtech_downloads_editing_x_y_frontend'], $vbphrase['dbtech_downloads_category'], $category['title']);

		if (($category['ownerid'] != $vbulletin->userinfo['userid'] OR !$vbulletin->userinfo['userid']) AND !VBDOWNLOADS::$permissions['ismanager'])
		{
			// Not owner
			eval(standard_error(fetch_error('dbtech_downloads_error_x', $vbphrase['dbtech_downloads_you_are_not_owner'])));
		}

		$category['title'] 			= htmlspecialchars_uni($category['title']);
		$category['description'] 	= htmlspecialchars_uni($category['description']);
		$category['image'] 			= htmlspecialchars_uni($category['image']);
	}
	else
	{
		// Add
		$category = $defaults;
	
		// Add to the navbits
		$navbits[''] = $pagetitle = $vbphrase['dbtech_downloads_add_new_category'];
	}

	// Set category owner
	$category['owner'] = $lookup[$category['ownerid']];

	$extensiongroups = array();
	foreach (VBDOWNLOADS::$cache['extensiongroup'] as $extensiongroupid => $extensiongroup)
	{
		$extensiongroups[$extensiongroupid] = $extensiongroup['title'];
	}

	$options = array(
		'parentid' 		=> '',
		'forumid' 		=> '',
		'extensions' 	=> '',
		'permissions' 	=> '',
	);

	$categories = array(0 => $vbphrase['n_a']);

	// Grab ordered list
	$categoryList = construct_ordered_categories();

	// Construct the list of select options
	construct_category_select_options($categories, $categoryList);

	foreach ($categories as $categoryid => $title)
	{
		/*
		if (in_array($download['categoryid'], $_excludeCategories))
		{
			// Can't view category
			continue;
		}
		*/

		$templater = vB_Template::create('option');
			$templater->register('optionselected', 	$category['parentid'] == $categoryid ? 'selected="selected"' : '');
			$templater->register('optionvalue', 	$categoryid);
			$templater->register('optiontitle', 	htmlspecialchars_uni($title));
		$options['parentid'] .= $templater->render();
	}

	$forums = construct_category_forum_chooser_options(true, '---------------');
	foreach ($forums as $forumid => $title)
	{
		$templater = vB_Template::create('option');
			$templater->register('optionselected', 	$category['forumid'] == $forumid ? 'selected="selected"' : '');
			$templater->register('optionvalue', 	$forumid);
			$templater->register('optiontitle', 	htmlspecialchars_uni($title));
		$options['forumid'] .= $templater->render();
	}

	$extensiongroups = array();
	foreach (VBDOWNLOADS::$cache['extensiongroup'] as $extensiongroupid => $extensiongroup)
	{
		$extensiongroups[$extensiongroupid] = $extensiongroup['title'];
	}

	// Sort out extension groups
	$options['extensions'] .= construct_checkbox_options('category[extensiongroups][]', $extensiongroups, $category['extensiongroups'], false);

	foreach ($vbulletin->usergroupcache as $usergroupid => $usergroup)
	{
		$templater = vB_Template::create('dbtech_downloads_category_modify_permissionbit');
			$templater->register('category', 	$category);
			$templater->register('usergroup', 	$usergroup);
		$options['permissions'] .= $templater->render();
	}	

	// Create the archive template
	$templater = vB_Template::create('dbtech_downloads_category_modify');
		$templater->register('pagetitle', 		$pagetitle);
		$templater->register('category', 		$category);
		$templater->register('options', 		$options);
		$templater->register('permissions', 	VBDOWNLOADS::$permissions);
	$HTML = $templater->render();
}

// #############################################################################
if ($_POST['action'] == 'update')
{
	// Grab stuff
	$vbulletin->input->clean_array_gpc('p', array(
		'categoryid' 	=> TYPE_UINT,
		'category' 		=> TYPE_ARRAY,
	));
	
	//$vbulletin->GPC['category']['title'] 			= htmlspecialchars_uni($vbulletin->GPC['category']['title']);
	//$vbulletin->GPC['category']['description'] 	= htmlspecialchars_uni($vbulletin->GPC['category']['description']);
		
	// init data manager
	$dm =& VBDOWNLOADS::initDataManager('Category', $vbulletin, ERRTYPE_STANDARD);
	
	// set existing info if this is an update
	if ($vbulletin->GPC['categoryid'])
	{
		if (!$existing = VBDOWNLOADS::$cache['category'][$vbulletin->GPC['categoryid']])
		{
			// Couldn't find the category
			eval(standard_error(fetch_error('dbtech_downloads_invalid_x', $vbphrase['dbtech_downloads_category'], $vbulletin->GPC['categoryid'])));
		}
		
		if (($existing['ownerid'] != $vbulletin->userinfo['userid'] OR !$vbulletin->userinfo['userid']) AND !VBDOWNLOADS::$permissions['ismanager'])
		{
			// Not owner
			eval(standard_error(fetch_error('dbtech_downloads_error_x', $vbphrase['dbtech_downloads_you_are_not_owner'])));
		}
		
		// Set existing
		$dm->set_existing($existing);
				
		// Added
		$phrase = $vbphrase['dbtech_downloads_edited'];
	}
	else
	{
		// Added
		$phrase = $vbphrase['dbtech_downloads_added'];
		
		// Locally set this
		$vbulletin->GPC['category']['ownerid'] = $vbulletin->userinfo['userid'];
	}
	
	if (!VBDOWNLOADS::$permissions['ismanager'])
	{
		// Managers don't need to moderate
		$moderated = 1;
		$dm->set('moderated', $moderated);

		// Managers can choose canprivate
		$canprivate = 0;
		$dm->set('canprivate', $canprivate);

		// Managers can choose canpassword
		$canpassword = 0;
		$dm->set('canpassword', $canpassword);

		// Managers can set permissions
		$permissions = array();
		foreach ($vbulletin->usergroupcache as $usergroupid => $usergroup)
		{
			$permissions['view'][$usergroupid] = 1;
			$permissions['download'][$usergroupid] = 1;
			$permissions['upload'][$usergroupid] = 1;
		}

		$dm->set('permissions', $permissions);
	}

	// category fields
	foreach ($vbulletin->GPC['category'] AS $key => $val)
	{
		if (!$vbulletin->GPC['categoryid'] OR $existing[$key] != $val)
		{
			// Only set changed values
			$dm->set($key, $val);
		}
	}
	
	// Save! Hopefully.
	$dm->save();

	// Success phrase
	$vbulletin->url = $vbulletin->options['dbtech_downloads_link'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'do=category';
	eval(print_standard_redirect('redirect_dbtech_downloads_category_updated'));	
}

// #############################################################################
if ($_POST['action'] == 'displayorder')
{
	$vbulletin->input->clean_array_gpc('p', array('order' => TYPE_ARRAY));
	
	if (is_array($vbulletin->GPC['order']))
	{
		foreach ($vbulletin->GPC['order'] as $categoryid => $displayorder)
		{
			if (!$existing = VBDOWNLOADS::$cache['category'][$categoryid])
			{
				// Couldn't find the category
				continue;
			}
			
			if ($existing['displayorder'] == $displayorder)
			{
				// No change
				continue;
			}
			
			if ($existing['ownerid'] != $vbulletin->userinfo['userid'] AND !VBDOWNLOADS::$permissions['ismanager'])
			{
				// No change
				continue;
			}
			
			// init data manager
			$dm =& VBDOWNLOADS::initDataManager('Category', $vbulletin, ERRTYPE_CP);
				$dm->set_existing($existing);
				$dm->set('displayorder', $displayorder);
			$dm->save();
			unset($dm);	
		}
	}
	
	$vbulletin->url = $vbulletin->options['dbtech_downloads_link'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'do=category';
	eval(print_standard_redirect('redirect_dbtech_downloads_category_updated'));
}